-- life meter.

local Player = ...
assert( Player );

local meterBaseLength = SCREEN_CENTER_X+4
local meterFillLength = meterBaseLength-11;
local meterFillOffset = 3;
local meterFillHeight = 26;

local newBPS;
local oldBPS;

local meter = Def.ActorFrame{
	Condition=GAMESTATE:IsSideJoined(Player) or GAMESTATE:IsPlayerEnabled(Player) or GAMESTATE:IsDemonstration();
	OnCommand=cmd(runcommandsonleaves,cmd(addy,-40;linear,0.2;addy,40));
	OffCommand=cmd(runcommandsonleaves,cmd(linear,1;diffusealpha,0));
	
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_square blackinset transparent normal", meterBaseLength-29, 10);
	
	-- // start meter proper //
	Def.Quad{
		Name="MeterFill";
		InitCommand=cmd(zoomto,0,meterFillHeight;diffuse,PlayerColor(Player);diffusebottomedge,PlayerMidColor(Player));
		BeginCommand=function(self)
			if Player == PLAYER_1 then self:horizalign(left);
			else self:horizalign(right);
			end;
			
			if Player == PLAYER_1 then self:addx(-(SCREEN_WIDTH/4)+meterFillOffset);
			else self:addx((SCREEN_WIDTH/4)-meterFillOffset);
			end;
		end;
		
		-- check state of mind
		HealthStateChangedMessageCommand=function(self,params)
			if(params.PlayerNumber == Player) then
				if(params.HealthState == 'HealthState_Hot') then
					self:glowshift();
					self:effectcolor1(color("1,1,1,0"));
					self:effectcolor2(color("1,1,1,0.25"));
					self:effectclock("beatnooffset");
				else
					self:stopeffect();
				end;
			end;
		end;
		
		-- check life
		LifeChangedMessageCommand=function(self,params)
			if(params.Player == Player) then
				local life = params.LifeMeter:GetLife() * (meterFillLength);
				self:accelerate(0.02);
				self:zoomx( life );
			end;
		end;
	};
	-- hot meter fill
	LoadActor("_hot")..{
		Name="MeterHotOverlay";
		InitCommand=cmd(diffusealpha,0;blend,'BlendMode_Add';setsize,meterFillLength,32); --zoomx,1.225;
		
		HealthStateChangedMessageCommand=function(self,params)
			if(params.PlayerNumber == Player) then
				if(params.HealthState == 'HealthState_Hot') then
					self:linear(0.1);
					self:diffusealpha(0.5);
				else
					self:linear(0.1);
					self:diffusealpha(0);
				end;
			else return;
			end;
		end;
	};
	
	-- dance points bg
	LoadActor("_dpmeter bg")..{
		Name="DancePointFrame";
		InitCommand=cmd(y,9);
		OnCommand=function(self)
			if Player == PLAYER_1 then self:horizalign(left);
			else self:horizalign(right);
			end;
			
			if Player == PLAYER_1 then self:addx(-(SCREEN_WIDTH/4)+3);
			else self:addx((SCREEN_WIDTH/4)-3);
			end;
		end;
	};
	
	-- dance points meter
	Def.Quad{
		Name="DancePointMeter";
		InitCommand=cmd(zoomto,0,4;y,9;diffuse,PlayerColor(Player));
		OnCommand=function(self)
			if Player == PLAYER_1 then self:horizalign(left);
			else self:horizalign(right);
			end;
			
			if Player == PLAYER_1 then self:addx(-(SCREEN_WIDTH/4)+5);
			else self:addx((SCREEN_WIDTH/4)-5);
			end;
		end;
		
		JudgmentMessageCommand=cmd(playcommand,"Update");
		UpdateCommand=function(self)
			local actualDP = STATSMAN:GetCurStageStats():GetPlayerStageStats(Player):GetActualDancePoints();
			local totalDP = STATSMAN:GetCurStageStats():GetPlayerStageStats(Player):GetPossibleDancePoints();
			self:zoomx((actualDP / totalDP) * 160);
		end;
	};
	
	-- dance points overlay
	Def.Quad{
		Name="DancePointOverlay";
		InitCommand=cmd(zoomto,160-5,4;y,9;diffuse,color("1,1,1,0.1");blend,'BlendMode_Add');
		OnCommand=function(self)
			if Player == PLAYER_1 then self:horizalign(left);
			else self:horizalign(right);
			end;
			
			if Player == PLAYER_1 then self:addx(-(SCREEN_WIDTH/4)+5);
			else self:addx((SCREEN_WIDTH/4)-5);
			end;
		end;
	};
};

local function Update(self)
	local hot = self:GetChild("MeterHotOverlay");
	
	newBPS = GAMESTATE:GetSongBPS();
	-- no need to play this again if the bps is the same!
	if newBPS == oldBPS then return end;
	
	local move = (newBPS*-1)/2;
	-- failed freeze mechanism
	if GAMESTATE:GetSongFreeze() then move = 0; end;
	hot:texcoordvelocity(move,0);
	oldBPS = newBPS;
end;

meter.InitCommand=cmd(SetUpdateFunction,Update)

return meter;